/**********************************************************************************************
COPYRIGHT (c) 2012.
HONEYWELL INC.,
ALL RIGHTS RESERVED
This software is a copyrighted work and/or information protected 
as a trade secret. Legal rights of Honeywell Inc. in this software 
is distinct from ownership of any medium in which the software is 
embodied. Copyright or trade secret notices included must be
reproduced in any copies authorized by Honeywell Inc.
The information in this software is subject to change without notice 
and should not be considered as a commitment by Honeywell Inc.
File Name : Form1.cs
Project Title : WPPDemo 
Version : -
Development Platform : Windows 7
Development Tool : Visual C#
Author(s) : -
Date of Creation : -
Last Modified : 07/18/2012
 *********************************************************************************************/

using System.Windows.Forms;
using System.Collections.Generic;
using System.ComponentModel;
using System;
using NCIHelperLib;

namespace WPPDemo
{
    public partial class Form1 : Form
    {
        // Fields
        private Dictionary<string, int> AccountMap = new Dictionary<string, int>();
        private Dictionary<string, int> SubAccountMap = new Dictionary<string, int>();
        public NCIHelperLib.Application app;
        private Button btn_PopulateHolidays;
        private Button btnAddTZRanges;
        private Button btnALPopulate;
        private Button btnBulkAdd;
        private Button btnBulkDelete;
        private Button btnCardHolders;
        private Button btnConfigDoorSchdule;
        private Button btnConnect;
        private Button btnDisconnect;
        private Button btnGetAATree;
        private Button btnGetAATreeBranch;
        private Button btngetAccounts;
        private Button btnGetALs;
        private Button btnGetCards;
        private Button btnGetDevices;
        private Button btnGetDeviceTZ;
        private Button btnGetGroups;
        private Button btnGetHG;
        private Button btnGetNoteFields;
        private Button btnGetOperator;
        private Button btnGetOutputs;
        private Button btnGetPanelTZ;
        private Button btnGetReaders;
        private Button btnGetSrchFields;
        private Button btnGetTZ;
        private Button btnLogout;
        private Button btnSearchCH;
        private Button button2;
        private Dictionary<int, string> CardHolderMap = new Dictionary<int, string>();
        private Dictionary<string, string> CardMap = new Dictionary<string, string>();
        private ComboBox cmbAccessBranches;
        private ComboBox cmbAccessLevels;
        private ComboBox cmbAccounts;
        private ComboBox cmbCardHolders;
        private ComboBox cmbCards;
        private ComboBox cmbComparator;
        private ComboBox cmbDevices;
        private ComboBox cmbDeviceTZs;
        private ComboBox cmbGroups;
        private ComboBox cmbHolidayGroups;
        private ComboBox cmbNoteFields;
        private ComboBox cmbOutputs;
        private ComboBox cmbPanelTZs;
        private ComboBox cmbReaders;
        private ComboBox cmbResCardHolders;
        private ComboBox cmbSearchFields;
        private ComboBox cmbTimezones;
        private Dictionary<string, int> DeviceMap = new Dictionary<string, int>();
        private Dictionary<int, int> DeviceParentMap = new Dictionary<int, int>();
        private Dictionary<string, int> GroupNameIDMap = new Dictionary<string, int>();
        private Dictionary<string, int> HolidayGrpMap = new Dictionary<string, int>();
        private Dictionary<string, string> NFMap = new Dictionary<string, string>();
        private Dictionary<string, int> OutputNameIDMap = new Dictionary<string, int>();
        private Dictionary<string, int> PanelMap = new Dictionary<string, int>();
        private Dictionary<string, int> ReaderNameIDMap = new Dictionary<string, int>();
        private Dictionary<string, int> ReaderPanelMap = new Dictionary<string, int>();
        private SplitContainer splitContainer;
        private Dictionary<string, int> TimezoneMap = new Dictionary<string, int>();
        private TextBox txtPassword;
        private TextBox txtSearchData;
        private TextBox txtUsername;

        private string m_sAccountName;
        private string m_sSubAccountName;
        private ICard theCard;
        private ICardHolder theCardHolder;

        // Methods
        public Form1()
        {
            this.InitializeComponent();
            m_sAccountName = "";
            m_sSubAccountName = "";

            try
            {
                app = new ApplicationClass();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
                throw;
            }
        }

        private void btn_PopulateHolidays_Click(object sender, EventArgs e)
        {
            int iStatus;
            HolidayGroupClass holidayGroup = new HolidayGroupClass
            {
                AccountID = 0,
                HolGrpName = "Pop HolidayGroup 1"
            };
            DateTime date = new DateTime(0x7dc, 1, 1);
            MasterHolidayClass[] holidays = new MasterHolidayClass[250];
            for (int i = 0; i < 250; i++)
            {
                holidays[i] = new MasterHolidayClass();
                holidays[i].AccountID = 0;
                holidays[i].HolidayType = 1;
                holidays[i].Name = "Pop Holiday " + ((i + 1)).ToString();
                holidays[i].Day = date.Day;
                holidays[i].Month = date.Month;
                holidays[i].Year = date.Year;
                date = date.AddDays(1.0);
            }
            this.app.AddHolidayGroup(holidayGroup, holidays, null, out iStatus);
            MessageBox.Show(iStatus.ToString());
        }

        private void btnAddTZRanges_Click(object sender, EventArgs e)
        {
            try
            {
                NCIHelperLib.TimeZoneClass[] tzRanges = new NCIHelperLib.TimeZoneClass[10];
                // Adds 2.00PM to 8.00PM for all days from Monday through Sunday
                // And Also to the H1, H2 and H3
                for (int i = 0; i < 10; i++)
                {
                    tzRanges[i] = new NCIHelperLib.TimeZoneClass();
                    tzRanges[i].DayType = i;
                    tzRanges[i].StartTime = "14:00";
                    tzRanges[i].EndTime = "20:00";
                    tzRanges[i].TZID = 6;
                }

                int iStatus;
                app.ConfigureTimeZoneRange(1, 6, tzRanges, out iStatus);

                switch (iStatus)
                {
                    case 0x69:
                        MessageBox.Show("InValid Account");
                        break;

                    case 0x25d:
                        MessageBox.Show("Invalid Time zone");
                        break;

                    case 0x25f:
                        MessageBox.Show("Invalid Time zone Range");
                        break;

                    case 0x260:
                        MessageBox.Show("Invalid DayType");
                        break;

                    case 0:
                        MessageBox.Show("Time Zone Range Configuration succeeded");
                        break;

                    case 1:
                        MessageBox.Show("Time Zone Range Configuration failed");
                        break;
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void btnALPopulate_Click(object sender, EventArgs e)
        {
            for (int i = 1; i <= 10; i++)
            {
                int iStatus;
                new AccessLevelClass();
                string sAcclName = "GURU_TZ_" + i.ToString();
                string sAcclDesc = "From API, for Population";
                long[] arrAcct = new long[0];
                this.app.CreateTimezone(sAcclName, sAcclDesc, arrAcct, out iStatus);
                if (iStatus > 0)
                {
                    MessageBox.Show(iStatus.ToString());
                    return;
                }
            }
        }

        private void btnBulkAdd_Click(object sender, EventArgs e)
        {
            DateTime dtActive = new DateTime();
            int iOpID = 0;
            string sOpName = "";
            this.app.GetCurrentOperator(out iOpID, out sOpName);
            object[] als = new object[] { 5 };
            this.app.BulkAddCards("1", "20", this.AccountMap[m_sAccountName], this.SubAccountMap[m_sSubAccountName], 0, dtActive, dtActive, iOpID, sOpName, 0, als);
        }

        private void btnBulkDelete_Click(object sender, EventArgs e)
        {
            int iOpID = 0;
            string sOpName = "";
            this.app.GetCurrentOperator(out iOpID, out sOpName);
            this.app.BulkDeleteCards("1", "15", 1, 0, iOpID, sOpName);
        }

        private void btnConfigDoorSchdule_Click(object sender, EventArgs e)
        {
            int iStatus = 0;
            this.app.ConfigureDoorSchedule(0x2f, 2, 0, out iStatus);
            MessageBox.Show(iStatus.ToString());
        }

        private void btnDisconnect_Click(object sender, EventArgs e)
        {
            this.app.DisConnectWPDatabase();
            MessageBox.Show("Disconnected");
        }

        private void btnGetAATree_Click(object sender, EventArgs e)
        {
            string sXML;
            this.app.GetAccessTreeByName("Master", m_sAccountName, out sXML);
            MessageBox.Show(sXML);
        }

        private void btnGetAATreeBranch_Click(object sender, EventArgs e)
        {
            string sAccountName;
            this.cmbAccessBranches.Items.Clear();
            this.cmbAccessBranches.Items.Add("Access Area");
            object branches = new object();
            this.app.GetAccountNameByAcctID(1, out sAccountName);
            this.app.GetAccessAreaBranchesByAccountName(sAccountName, out branches);
            if (branches != null)
            {
                string[] sBranchArray = (string[])branches;
                foreach (string sBranch in sBranchArray)
                {
                    this.cmbAccessBranches.Items.Add(sBranch);
                }
            }
        }

        private void btnGetDevices_Click(object sender, EventArgs e)
        {
            string sAcctName;
            this.cmbDevices.Items.Clear();
            this.DeviceMap.Clear();
            this.app.GetAccountNameByAcctID(1, out sAcctName);
            object Devices = new HWDeviceClass();
            this.app.GetADVDetailsByAccountName(sAcctName, out Devices);
            if (Devices != null)
            {
                object[] DeviceArray = (object[])Devices;
                int nDevices = DeviceArray.Length;
                for (int j = 0; j < nDevices; j++)
                {
                    IHWDevice objDevice = (IHWDevice)DeviceArray[j];
                    this.DeviceMap.Add(objDevice.DeviceName, objDevice.DeviceID);
                    this.cmbDevices.Items.Add(objDevice.DeviceName);
                }
                if (nDevices > 0)
                    this.cmbDevices.SelectedIndex = 0;

            }
        }

        private void btnGetDeviceTZ_Click(object sender, EventArgs e)
        {
            string sAcctName;
            this.cmbDeviceTZs.Items.Clear();
            this.DeviceParentMap.Clear();
            this.app.GetAccountNameByAcctID(1, out sAcctName);
            object Devices = new HWDeviceClass();
            this.app.GetADVDetailsByAccountName(sAcctName, out Devices);
            if (Devices != null)
            {
                object[] DeviceArray = (object[])Devices;
                int nDevices = DeviceArray.Length;
                for (int j = 0; j < nDevices; j++)
                {
                    IHWDevice objDevice = (IHWDevice)DeviceArray[j];
                    this.DeviceParentMap.Add(objDevice.DeviceID, objDevice.HWDeviceID);
                    this.cmbDeviceTZs.Items.Add(objDevice.DeviceID);
                }
                if (nDevices > 0)
                    this.cmbDeviceTZs.SelectedIndex = 0;
            }
        }

        private void btnGetGroups_Click(object sender, EventArgs e)
        {
            this.cmbGroups.Items.Clear();
            this.GroupNameIDMap.Clear();
            object Panels = new HWDeviceClass();
            this.app.GetPanelsByAcctID(1, out Panels);
            if (Panels != null)
            {
                object[] panelArray = (object[])Panels;
                int nCards = panelArray.Length;
                for (int j = 0; j < nCards; j++)
                {
                    IHWDevice objPanel = (IHWDevice)panelArray[j];
                    object Groups = new HWDeviceClass();
                    this.app.GetGroupsByPanelID(1, objPanel.HWDeviceID, out Groups);
                    if (Groups != null)
                    {
                        object[] DeviceArray = (object[])Groups;
                        int nOuts = DeviceArray.Length;
                        for (int i = 0; i < nOuts; i++)
                        {
                            IHWDevice objDevice = (IHWDevice)DeviceArray[i];
                            this.cmbGroups.Items.Add(objDevice.DeviceName);
                            this.GroupNameIDMap.Add(objDevice.DeviceName, objDevice.DeviceID);
                        }
                        if (nOuts > 0)
                            this.cmbGroups.SelectedIndex = 0;
                    }
                }
            }
        }

        private void btnGetHG_Click(object sender, EventArgs e)
        {
            this.cmbHolidayGroups.Items.Clear();
            this.HolidayGrpMap.Clear();
            object HolidayGroups = new HolidayGroupClass();
            this.app.GetHolidayGroupsByAcctID(0, out HolidayGroups);
            if (HolidayGroups != null)
            {
                object[] HGs = (object[])HolidayGroups;
                int nHGs = HGs.Length;
                for (int j = 0; j < nHGs; j++)
                {
                    IHolidayGroup objHG = (IHolidayGroup)HGs[j];
                    this.HolidayGrpMap.Add(objHG.HolGrpName, objHG.HolGrpID);
                    this.cmbHolidayGroups.Items.Add(objHG.HolGrpName);
                }
                if (nHGs > 0)
                    this.cmbHolidayGroups.SelectedIndex = 0;
            }
        }

        private void btnGetNoteFields_Click(object sender, EventArgs e)
        {
            this.cmbNoteFields.Items.Clear();
            this.NFMap.Clear();
            object noteFields = new object();
            this.app.GetNoteFieldTemplateDetailsByAccount(m_sAccountName, m_sSubAccountName, out noteFields);
            if (noteFields != null)
            {
                object[] nfArray = (object[])noteFields;
                int nNFs = nfArray.Length;
                for (int j = 0; j < nNFs; j++)
                {
                    INoteField objNF = (INoteField)nfArray[j];
                    this.NFMap.Add(objNF.NoteFieldName, objNF.FieldDefinition);
                    this.cmbNoteFields.Items.Add(objNF.NoteFieldName);
                }
                if (nNFs > 0)
                    this.cmbNoteFields.SelectedIndex = 0;
            }

            //object accounts = new WPAccountClass();
            //this.app.GetAccounts(out accounts);
            //if (accounts != null)
            //{
            //    object[] foo = (object[])accounts;
            //    int nSize = foo.Length;
            //    for (int i = 0; i < nSize; i++)
            //    {
            //        IAccount obj = (IAccount)foo[i];
            //        object noteFields = new object();
            //        this.app.GetNoteFieldTemplateDetailsByAccount(obj.AccountName, out noteFields);
            //        if (noteFields != null)
            //        {
            //            object[] nfArray = (object[])noteFields;
            //            int nCards = nfArray.Length;
            //            for (int j = 0; j < nCards; j++)
            //            {
            //                INoteField objNF = (INoteField)nfArray[j];
            //                this.NFMap.Add(objNF.NoteFieldName, objNF.FieldDefinition);
            //                this.cmbNoteFields.Items.Add(objNF.NoteFieldName);
            //            }
            //        }
            //    }
            //}
        }

        private void btnGetOperator_Click(object sender, EventArgs e)
        {
            int iOpID = 0;
            string sOpName = "";
            this.app.GetCurrentOperator(out iOpID, out sOpName);
            MessageBox.Show(("Operator Name : " + sOpName) + "\nOperator ID : " + iOpID);
        }

        private void btnGetOutputs_Click(object sender, EventArgs e)
        {
            this.cmbOutputs.Items.Clear();
            this.OutputNameIDMap.Clear();
            object Panels = new HWDeviceClass();
            this.app.GetPanelsByAcctID(1, out Panels);
            if (Panels != null)
            {
                object[] panelArray = (object[])Panels;
                int nCards = panelArray.Length;
                for (int j = 0; j < nCards; j++)
                {
                    IHWDevice objPanel = (IHWDevice)panelArray[j];
                    object Outputs = new HWDeviceClass();
                    this.app.GetOutputsByPanelID(1, objPanel.HWDeviceID, out Outputs);
                    if (Outputs != null)
                    {
                        object[] DeviceArray = (object[])Outputs;
                        int nOuts = DeviceArray.Length;
                        for (int i = 0; i < nOuts; i++)
                        {
                            IHWDevice objDevice = (IHWDevice)DeviceArray[i];
                            this.cmbOutputs.Items.Add(objDevice.DeviceName);
                            this.OutputNameIDMap.Add(objDevice.DeviceName, objDevice.DeviceID);
                        }
                        if (nOuts > 0)
                            this.cmbOutputs.SelectedIndex = 0;
                    }
                }
            }
        }

        private void btnGetPanelTZ_Click(object sender, EventArgs e)
        {
            this.cmbPanelTZs.Items.Clear();
            this.PanelMap.Clear();
            object Panels = new HWDeviceClass();
            this.app.GetPanelsByAcctID(0, out Panels);
            if (Panels != null)
            {
                object[] panelArray = (object[])Panels;
                int nPTZs = panelArray.Length;
                for (int j = 0; j < nPTZs; j++)
                {
                    IHWDevice objPanel = (IHWDevice)panelArray[j];
                    this.PanelMap.Add(objPanel.DeviceName, objPanel.HWDeviceID);
                    this.cmbPanelTZs.Items.Add(objPanel.DeviceName);
                }
                if (nPTZs > 0)
                    this.cmbPanelTZs.SelectedIndex = 0;
            }
        }

        private void btnGetReaders_Click(object sender, EventArgs e)
        {
            string sAcctName;
            this.cmbReaders.Items.Clear();
            this.ReaderNameIDMap.Clear();
            this.ReaderPanelMap.Clear();
            this.app.GetAccountNameByAcctID(1, out sAcctName);
            object Readers = new HWDeviceClass();
            this.app.GetReadersByAccountName(sAcctName, out Readers);
            if (Readers != null)
            {
                object[] DeviceArray = (object[])Readers;
                int nRdrs = DeviceArray.Length;
                for (int j = 0; j < nRdrs; j++)
                {
                    IHWDevice objDevice = (IHWDevice)DeviceArray[j];
                    this.ReaderNameIDMap.Add(objDevice.DeviceName, objDevice.DeviceID);
                    this.ReaderPanelMap.Add(objDevice.DeviceName, objDevice.HWDeviceID);
                    this.cmbReaders.Items.Add(objDevice.DeviceName);
                }
                if (nRdrs > 0)
                    this.cmbReaders.SelectedIndex = 0;
            }
        }

        private void btnGetSrchFields_Click(object sender, EventArgs e)
        {
            this.cmbSearchFields.Items.Clear();
            object oSearchFields = new object();
            this.app.GetCardHolderSearchFieldsByAccountName(m_sAccountName, m_sSubAccountName, out oSearchFields);
            if (oSearchFields != null)
            {
                string[] arrFieldNames = (string[])oSearchFields;
                foreach (string sName in arrFieldNames)
                {
                    this.cmbSearchFields.Items.Add(sName);
                }
                if (arrFieldNames.Length > 0)
                    this.cmbNoteFields.SelectedIndex = 0;
            }
        }

        private void btnGetTZ_Click(object sender, EventArgs e)
        {
            this.cmbTimezones.Items.Clear();
            this.TimezoneMap.Clear();
            object timezones = new TimeZoneClass();
            this.app.GetAllTimezones(out timezones);
            if (timezones != null)
            {
                object[] TZs = (object[])timezones;
                int nTZs = TZs.Length;
                for (int j = 0; j < nTZs; j++)
                {
                    ITimeZone objTZ = (ITimeZone)TZs[j];
                    this.TimezoneMap.Add(objTZ.TimeZoneName, objTZ.TimeZoneID);
                    this.cmbTimezones.Items.Add(objTZ.TimeZoneName);
                }
                if (nTZs > 0)
                    this.cmbTimezones.SelectedIndex = 0;
            }
        }

        private void btnLogout_Click(object sender, EventArgs e)
        {
            this.app.Logout();
            MessageBox.Show("Logged Out");
        }

        private void btnSearchCH_Click(object sender, EventArgs e)
        {
            int iComparator = -1;
            string sSearchField = this.cmbSearchFields.Text;
            string sSearchData = this.txtSearchData.Text;
            if (this.cmbComparator.Text.Length != 0)
            {
                iComparator = this.cmbComparator.Items.IndexOf(this.cmbComparator.Text);
            }
            string[] arrSearchFields = new string[1];
            string[] arrSearchDatas = new string[1];
            int[] arrSearchCmps = new int[1];
            arrSearchFields[0] = sSearchField;
            arrSearchDatas[0] = sSearchData;
            arrSearchCmps[0] = iComparator;
            this.cmbResCardHolders.Items.Clear();
            object cardHolders = new CardHolderClass();
            this.app.GetCardHoldersOnSearch(m_sAccountName, m_sSubAccountName, arrSearchFields, arrSearchDatas, arrSearchCmps, out cardHolders);
            if (cardHolders != null)
            {
                object[] CHs = (object[])cardHolders;
                int nCHs = CHs.Length;
                for (int j = 0; j < nCHs; j++)
                {
                    ICardHolder objCardHolder = (ICardHolder)CHs[j];
                    this.cmbResCardHolders.Items.Add(objCardHolder.CardHolderID);
                }
                if (nCHs > 0)
                    this.cmbResCardHolders.SelectedIndex = 0;
            }
            /*
            if (cardHolders != null)
            {
                object[] CHs = (object[])cardHolders;
                DetailView details = new DetailView();
                details.populateCardHolders(CHs);
                details.Show();
            }
             */
        }

        private void button2_Click(object sender, EventArgs e)
        {
            int iStatus;
            int lUserID = 1;
            this.app.ConnectWPDatabase(this.txtUsername.Text, this.txtPassword.Text, "", out iStatus, lUserID);
            if (iStatus != 0)
            {
                MessageBox.Show("Login Failed");
            }
            else
            {
                string DBServerTZ;
                int iDST;
                string strDetails = "Login Success";
                int iOffset = 0;
                this.app.GetWPDBServerTZ(out DBServerTZ, out iDST);
                strDetails = (strDetails + "\n\nWP DB Server TZ : " + DBServerTZ) + "\nWP DB Server TZ DST : " + iDST.ToString();
                this.app.GetWPDBServerTZoffset(ref iOffset);
                MessageBox.Show(strDetails + "\nWP DB Server TZ Offset : " + iOffset.ToString());
            }
        }

        private void cmbAccessBranches_SelectedIndexChanged(object sender, EventArgs e)
        {
            string sAccountName;
            object Readers = new object();
            object TZs = new TimeZoneClass();
            string strDetails = "Readers :";
            this.app.GetAccountNameByAcctID(1, out sAccountName);
            this.app.GetReadersInAccessAreaBranch(sAccountName, this.cmbAccessBranches.Text, out Readers);
            if (Readers != null)
            {
                string[] readerArray = (string[])Readers;
                foreach (string sReader in readerArray)
                {
                    strDetails = strDetails + "\n" + sReader;
                }
            }
            strDetails = strDetails + "\nTimezones :";
            this.app.GetAvailableTimezonesOfBranch(sAccountName, this.cmbAccessBranches.Text, out TZs);
            if (TZs != null)
            {
                object[] tzArray = (object[])TZs;
                foreach (ITimeZone theTZ in tzArray)
                {
                    strDetails = strDetails + "\n" + theTZ.TimeZoneName;
                }
            }
            MessageBox.Show(strDetails);
        }

        private void cmbAccessLevels_SelectedValueChanged(object sender, EventArgs e)
        {
            object accessLevel = new AccessLevelClass();
            string sAcctName = "";
            string sAcclName = "";
            string strDetails = "";
            this.app.GetAccountNameByAcctID(1, out sAcctName);
            this.app.GetAccessLevelByName(this.cmbAccessLevels.Text, sAcctName, out accessLevel);
            if (accessLevel != null)
            {
                IAccessLevel theAL = (IAccessLevel)accessLevel;
                strDetails = ("AccessLevel Name: " + theAL.AccessLevelName) + "\nAccount Name: " + theAL.AccountName;
                sAcctName = theAL.AccountName;
                sAcclName = theAL.AccessLevelName;
            }
            strDetails = strDetails + "\nAccess Levels For Reassign :";
            object OtherALs = new AccessLevelClass();
            this.app.GetAccesslevelsForReassign(sAcctName, sAcclName, out OtherALs);
            if (OtherALs != null)
            {
                object[] accls = (object[])OtherALs;
                int nSizeAL = accls.Length;
                for (int j = 0; j < nSizeAL; j++)
                {
                    IAccessLevel objAL = (IAccessLevel)accls[j];
                    strDetails = (strDetails + "\nAccess Level Name : " + objAL.AccessLevelName) + "\nAccount Name : " + objAL.AccountName;
                }
            }
            strDetails = strDetails + "\nAssociated Cards :";
            object cards = new CardClass();
            int iStatus = 0;
            this.app.IsolateAccessLevel(sAcclName, sAcctName, out cards, out iStatus);
            if (cards != null)
            {
                object[] crds = (object[])cards;
                int nCards = crds.Length;
                for (int j = 0; j < nCards; j++)
                {
                    string cardNo = (string)crds[j];
                    strDetails = strDetails + "\n" + cardNo;
                }
            }
            MessageBox.Show(strDetails);

            int iConnected = 0;
            this.app.IsConnected(ref iConnected);

           

            string sAccessTree = "";

            this.app.GetAccessTreeByName(sAcclName, sAcctName, out sAccessTree);

            //MessageBox.Show(sAccessTree);
            AccessTreeView treeView = new AccessTreeView();

            treeView.LoadTreeViewFromXml(sAccessTree);

            treeView.Show();
        }

        private void cmbAccounts_SelectedValueChanged(object sender, EventArgs e)
        {
            string strDetails = "";
            object account = new WPAccountClass();
            this.app.GetAccountByAcctID(this.AccountMap[this.cmbAccounts.Text], out account);
            if (account != null)
            {
                IAccount theAccount = (IAccount)account;
                strDetails = ("Account Name: " + theAccount.AccountName) + "\nAccount ID : " + theAccount.AccountID;
                m_sAccountName = theAccount.AccountName;

                //SubAccount
                m_sSubAccountName = "";

                this.cb_subAccouts.Items.Clear();
                this.SubAccountMap.Clear();

                this.cmbCards.Items.Clear();
                this.cmbAccessLevels.Items.Clear();
                this.cmbCardHolders.Items.Clear();
                this.cmbNoteFields.Items.Clear();
                this.cmbResCardHolders.Items.Clear();
                

                //Account
                this.cmbDevices.Items.Clear();
                this.cmbDeviceTZs.Items.Clear();
                this.cmbGroups.Items.Clear();                
                this.cmbOutputs.Items.Clear();
                this.cmbPanelTZs.Items.Clear();
                this.cmbReaders.Items.Clear();                
                this.cmbTimezones.Items.Clear();
                
            }
            
            MessageBox.Show(strDetails + "\nReader TZ Details : " + this.app.GetReaderTZDetailsByAccountId(this.AccountMap[this.cmbAccounts.Text]));
        }

        private void cmbCard_SelectedValueChanged(object sender, EventArgs e)
        {
            object card = new CardClass();
            this.app.GetCardbyCardNumber(this.cmbCards.Text, m_sAccountName, m_sSubAccountName, out card);
            if (card != null)
            {
                theCard = (ICard)card;
                MessageBox.Show((((("Account : " + theCard.AccountName) + "\nCard# : " + theCard.CardNumber) + "\nCardID : " + theCard.CardHolderID) + "\nActivation Date : " + theCard.ActivationDate) + "\nExpiration Date : " + theCard.ExpirationDate);
            }
        }

        private void cmbCardHolders_SelectedValueChanged(object sender, EventArgs e)
        {
            object CardHolder = new CardHolderClass();
            this.app.GetCardHolderByCardHolderID(int.Parse(this.cmbCardHolders.Text), out CardHolder);
            //this.app.GetCardHolderByExtRefID(this.AccountMap[m_sAccountName], this.SubAccountMap[m_sSubAccountName], "", out CardHolder);
            if (CardHolder != null)
            {
                ICardHolder theCH = (ICardHolder)CardHolder;
                string strDetails = (((("First Name: " + theCH.FirstName) + "\nLast Name: " + theCH.LastName) + "\nAccount Name: " + theCH.AccountName) + "\nCard Holder ID: " + theCH.CardHolderID.ToString()) + "\nAssociated Cards :";
                object AssociatedCards = new CardClass();
                this.app.GetCardsByCHID(theCH.CardHolderID, out AssociatedCards);
                if (AssociatedCards != null)
                {
                    object[] cardArray = (object[])AssociatedCards;
                    foreach (ICard theCard in cardArray)
                    {
                        strDetails = strDetails + "\n" + theCard.CardNumber;
                    }
                }
                else
                {
                    strDetails = strDetails + "\nNone";
                }

                // Photo Size
                uint uPhotoSize = 0;
                app.GetPhotoSize((uint)theCH.CardHolderID, 1, ref uPhotoSize);

                strDetails += "\nPhoto Size : " + uPhotoSize.ToString() + " bytes";
                strDetails = strDetails + "\nUnassociated Cards :";
                /*
                object UnassociatedCards = new CardClass();
                this.app.GetCardsWithoutCHIDByAcctID(this.AccountMap[m_sAccountName], 0, out UnassociatedCards);
                if (UnassociatedCards != null)
                {
                    object[] cardArray = (object[])UnassociatedCards;
                    foreach (ICard theCard in cardArray)
                    {
                        strDetails = strDetails + "\n" + theCard.CardNumber;
                    }
                }
                else
                {
                    strDetails = strDetails + "\nNone";
                }
                */
                theCardHolder = theCH;
                MessageBox.Show(strDetails);
            }
        }

        private void cmbDevices_SelectedIndexChanged(object sender, EventArgs e)
        {
            object Device = new HWDeviceClass();
            this.app.GetADVDetailsByHID(this.DeviceMap[this.cmbDevices.Text], out Device);
            if (Device != null)
            {
                IHWDevice theDevice = (IHWDevice)Device;
                MessageBox.Show(((("Device Name : " + theDevice.DeviceName) + "\nDevice Type : " + theDevice.DeviceType.ToString()) + "\nDevice ID : " + theDevice.DeviceID.ToString()) + "\nHWDeviceID : " + theDevice.HWDeviceID.ToString());
            }
        }

        private void cmbDeviceTZs_SelectedIndexChanged(object sender, EventArgs e)
        {
            string sDeviceName;
            object confTZ = new object();
            this.app.GetDevNameByDeviceID(int.Parse(this.cmbDeviceTZs.Text), out sDeviceName);
            string strDetails = "Device Name : " + sDeviceName;
            this.app.GetAssociatedTimezoneOfGroup(1, this.DeviceParentMap[int.Parse(this.cmbDeviceTZs.Text)], int.Parse(this.cmbDeviceTZs.Text), out confTZ);
            if (confTZ != null)
            {
                ITimeZone objTZ = (ITimeZone)confTZ;
                strDetails = strDetails + "\nGroup Timezone : " + objTZ.TimeZoneName;
            }
            else
            {
                strDetails = strDetails + "\nNot a Group";
                this.app.GetAssociatedTimezoneOfOutput(1, this.DeviceParentMap[int.Parse(this.cmbDeviceTZs.Text)], int.Parse(this.cmbDeviceTZs.Text), out confTZ);
                if (confTZ != null)
                {
                    ITimeZone objTZ = (ITimeZone)confTZ;
                    strDetails = strDetails + "\nOutput Timezone : " + objTZ.TimeZoneName;
                }
                else
                {
                    strDetails = strDetails + "\nNot a Output";
                }
            }
            MessageBox.Show(strDetails);
        }

        private void cmbHolidayGroups_SelectedValueChanged(object sender, EventArgs e)
        {
            object Holidays = new MasterHolidayClass();
            string strDetails = "Holiday Grp Name : " + this.cmbHolidayGroups.Text;
            this.app.GetHolidaysByHolidayGroupID(this.HolidayGrpMap[this.cmbHolidayGroups.Text], out Holidays);
            if (Holidays != null)
            {
                object[] HolidayArray = (object[])Holidays;
                int nSize = HolidayArray.Length;
                for (int j = 0; j < nSize; j++)
                {
                    IMasterHoliday objHoliday = (IMasterHoliday)HolidayArray[j];
                    strDetails = (strDetails + "\nHoliday Name : " + objHoliday.Name) + "\nHoliday Type : " + objHoliday.HolidayType.ToString();
                }
                MessageBox.Show(strDetails);
            }
        }

        private void cmbNoteFields_SelectedIndexChanged(object sender, EventArgs e)
        {
            MessageBox.Show(("NoteField Name : " + this.cmbNoteFields.Text) + "\nNoteField Template : " + this.NFMap[this.cmbNoteFields.Text]);
        }

        private void cmbPanelTZs_SelectedIndexChanged(object sender, EventArgs e)
        {
            object panelTZs = new TimeZoneClass();
            object panelOutputs = new HWDeviceClass();
            object panelGroups = new HWDeviceClass();
            object panelHGs = new object();
            int iGrpOption = 0;
            string strDetails = "Panel Details";
            this.app.GetAvailableTimezonesOfPanel(1, this.PanelMap[this.cmbPanelTZs.Text], out panelTZs);
            if (panelTZs != null)
            {
                object[] tzArray = (object[])panelTZs;
                int nCards = tzArray.Length;
                for (int j = 0; j < nCards; j++)
                {
                    ITimeZone objTZ = (ITimeZone)tzArray[j];
                    strDetails = (strDetails + "\nTimezone : " + objTZ.TimeZoneName) + "\nSlot Index : " + objTZ.PanelTZSlotIndex.ToString();
                }
            }
            this.app.GetOutputsByPanelID(1, this.PanelMap[this.cmbPanelTZs.Text], out panelOutputs);
            if (panelOutputs != null)
            {
                object[] outArray = (object[])panelOutputs;
                int nCards = outArray.Length;
                for (int j = 0; j < nCards; j++)
                {
                    IHWDevice theDevice = (IHWDevice)outArray[j];
                    strDetails = strDetails + "\nOutput Name : " + theDevice.DeviceName;
                }
            }
            this.app.GetGroupsByPanelID(1, this.PanelMap[this.cmbPanelTZs.Text], out panelGroups);
            if (panelGroups != null)
            {
                object[] GrpArray = (object[])panelOutputs;
                int nCards = GrpArray.Length;
                for (int j = 0; j < nCards; j++)
                {
                    IHWDevice theDevice = (IHWDevice)GrpArray[j];
                    strDetails = strDetails + "\nGroup Name : " + theDevice.DeviceName;
                }
            }
            this.app.GetConfiguredHolidayGroupsByPanel(this.PanelMap[this.cmbPanelTZs.Text], out panelHGs);
            if (panelHGs != null)
            {
                int[] HGs = (int[])panelHGs;
                int nCards = HGs.Length;
                for (int j = 0; j < nCards; j++)
                {
                    strDetails = strDetails + "\nHoliday Group Name : " + HGs[j].ToString();
                }
            }
            this.app.IsGroupChecked(1, this.PanelMap[this.cmbPanelTZs.Text], ref iGrpOption);
            MessageBox.Show(strDetails + "\nGroup Option : " + iGrpOption.ToString());
        }

        private void cmbReaders_SelectedIndexChanged(object sender, EventArgs e)
        {
            int DirectPointDeviceID;
            int DirectPointTZID;
            string sReaderName = this.cmbReaders.Text;
            string strDetails = sReaderName;
            object ReaderGroups = new HWDeviceClass();
            object ReaderTZs = new TimeZoneClass();
            this.app.GetDirectPointTZDetailsofReader(this.ReaderNameIDMap[sReaderName], out DirectPointDeviceID, out DirectPointTZID);
            strDetails = ((strDetails + "\nDirect Point : " + DirectPointDeviceID.ToString()) + "\nDirect Point TZ : " + DirectPointTZID.ToString()) + "\nAvailable Timezones:";
            this.app.GetAvailableTimeZonesOfReader(sReaderName, out ReaderTZs);
            this.app.GetAvailableGroupsofReader(sReaderName, out ReaderGroups);
            if (ReaderTZs != null)
            {
                object[] tzArray = (object[])ReaderTZs;
                foreach (ITimeZone theTZ in tzArray)
                {
                    strDetails = strDetails + "\n" + theTZ.TimeZoneName;
                }
            }
            strDetails = strDetails + "\nAvailable Groups:";
            if (ReaderGroups != null)
            {
                object[] grpArray = (object[])ReaderGroups;
                foreach (IHWDevice theGroup in grpArray)
                {
                    strDetails = strDetails + "\n" + theGroup.DeviceName;
                }
            }
            MessageBox.Show(strDetails);
        }

        private void cmbTimezones_SelectedValueChanged(object sender, EventArgs e)
        {
            object tzRanges = new object();
            string TZName = this.cmbTimezones.Text;
            string strDetails = "Timezone Name : " + TZName;
            this.app.GetTimeZoneRangesByTZID(this.TimezoneMap[this.cmbTimezones.Text], out tzRanges);
            if (tzRanges != null)
            {
                object[] TZRangeArray = (object[])tzRanges;
                int nSize = TZRangeArray.Length;
                for (int j = 0; j < nSize; j++)
                {
                    ITimeZoneRange objTZRange = (ITimeZoneRange)TZRangeArray[j];
                    strDetails = ((strDetails + "\nStart Time : " + objTZRange.StartTime) + "\nEnd Time : " + objTZRange.EndTime) + "\nDay : " + objTZRange.DayType.ToString();
                }
                MessageBox.Show(strDetails);
            }
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            this.app.Logout();
        }

        private void onbthGetCardsClick(object sender, EventArgs e)
        {
            this.cmbCards.Items.Clear();
            this.CardMap.Clear();
            
            object cards = new CardClass();
            if (string.IsNullOrEmpty(m_sAccountName))
            {
                MessageBox.Show("Select Account First!!");
                return;
            }
            if (string.IsNullOrEmpty(m_sSubAccountName))
            {
                MessageBox.Show("Select SubAccount First!!");
                return;
            }
            this.app.GetCardsByAccountName(m_sAccountName, m_sSubAccountName, out cards);

            if (cards != null)
            {
                object[] crds = (object[])cards;
                int nCards = crds.Length;
                for (int j = 0; j < nCards; j++)
                {
                    ICard objCard = (ICard)crds[j];
                    this.CardMap.Add(objCard.CardNumber, m_sSubAccountName);
                    this.cmbCards.Items.Add(objCard.CardNumber);
                }
            }

        }

        private void onbtnGetAccountsClick(object sender, EventArgs e)
        {
            this.cmbAccounts.Items.Clear();
            this.AccountMap.Clear();
            object accounts = new WPAccountClass();
            this.app.GetAccounts(out accounts);
            if (accounts != null)
            {
                object[] foo = (object[])accounts;
                int nSize = foo.Length;
                for (int i = 0; i < nSize; i++)
                {
                    IAccount obj = (IAccount)foo[i];
                    this.AccountMap.Add(obj.AccountName, obj.AccountID);
                    this.cmbAccounts.Items.Add(obj.AccountName);
                }
            }
        }

        private void onbtnGetALClick(object sender, EventArgs e)
        {
            object ALs = new AccessLevelClass();
            this.app.GetAllAccessLevels(out ALs);
            if (ALs != null)
            {
                object[] accls = (object[])ALs;
                int nSizeAL = accls.Length;
                for (int j = 0; j < nSizeAL; j++)
                {
                    IAccessLevel objAL = (IAccessLevel)accls[j];
                    this.cmbAccessLevels.Items.Add(objAL.AccessLevelName);
                }
            }
        }

        private void onbtnGetCardHolderClick(object sender, EventArgs e)
        {
            this.cmbCardHolders.Items.Clear();
            //for the return from getcardholdersbyaccountname()
            object cardHolders = new CardHolderClass();
            // Now we got the _ComObject on GetCardHoldersByAccountName()
            this.app.GetCardHoldersByAccountName(m_sAccountName, m_sSubAccountName, out cardHolders);
            if (cardHolders != null)
            {
                object[] CHs = (object[])cardHolders;

                //DetailView details = new DetailView();
                //details.populateCardHolders(CHs);
                //details.Show();

                int nCHs = CHs.Length;
                for (int j = 0; j < nCHs; j++)
                {
                    // Decoding the General Object into a specific 
                    //CardHolder Object through NCIHelperLib.ICardHolder
                    ICardHolder objCardHolder = (ICardHolder)CHs[j];
                    this.cmbCardHolders.Items.Add(objCardHolder.CardHolderID);
                }

                if (nCHs > 0)
                    cmbCardHolders.SelectedIndex = 0;
            }

            //object accounts = new WPAccountClass();
            //this.app.GetAccounts(out accounts); 
            //if (accounts != null)
            //{
            //    object[] foo = (object[])accounts;
            //    int nsize = foo.Length;
            //    for (int i = 0; i < nsize; i++)
            //    {
            //        // generic _comobject to iaccount object
            //        IAccount obj = (IAccount)foo[i];
            //        //cardholders is general container ... 
            //        //for the return from getcardholdersbyaccountname()
            //        object cardHolders = new CardHolderClass();
            //        // Now we got the _ComObject on GetCardHoldersByAccountName()
            //        this.app.GetCardHoldersByAccountName(m_sAccountName, m_sSubAccountName, out cardHolders); 
            //        if (cardHolders != null)
            //        {
            //            object[] CHs = (object[])cardHolders;
                        
            //            //DetailView details = new DetailView();
            //            //details.populateCardHolders(CHs);
            //            //details.Show();

            //            int nCards = CHs.Length;
            //            for (int j = 0; j < nCards; j++)
            //            {
            //                // Decoding the General Object into a specific 
            //                //CardHolder Object through NCIHelperLib.ICardHolder
            //                ICardHolder objCardHolder = (ICardHolder)CHs[j]; 
            //                this.cmbCardHolders.Items.Add(objCardHolder.CardHolderID);
            //            }
            //        }
            //    }
            //}
        }

        private void onbtnLoginClick(object sender, EventArgs e)
        {
            int lUserID;
            this.app.Login(this.txtUsername.Text, this.txtPassword.Text, "", out lUserID);
            
            if (lUserID <= 0)
            {
                MessageBox.Show("Login Failed");
            }
            else
            {
                string DBServerTZ;
                int iDST;
                string strDetails = "Login Success";
                int iOffset = 0;
                this.app.GetWPDBServerTZ(out DBServerTZ, out iDST);
                strDetails = (strDetails + "\n\nWP DB Server TZ : " + DBServerTZ) + "\nWP DB Server TZ DST : " + iDST.ToString();
                this.app.GetWPDBServerTZoffset(ref iOffset);
                MessageBox.Show(strDetails + "\nWP DB Server TZ Offset : " + iOffset.ToString());
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            NCIHelperLib.AccessLevel newAL= new AccessLevel();

            newAL.AccountName = m_sAccountName;
            string[] subacctname = new string[1];
            subacctname[0] = m_sSubAccountName;
            newAL.SubAccountNames = (object)subacctname;
            newAL.AccessLevelName = "New AL";
            newAL.AccessLevelDesc = "Added for the Debug FN Motol API Issue";

            int iStatus = 0;
            app.AddAccessLevel(newAL, out iStatus);

            if (iStatus == 202)
            {
                app.DeleteAccessLevel("New AL", m_sAccountName, out iStatus);
                app.AddAccessLevel(newAL, out iStatus);
            }

            object Readers = new object();
                   
            this.app.GetReadersInAccessAreaBranch(m_sAccountName, "FN Motol", out Readers);
            if (Readers == null)
            {
                MessageBox.Show("No Readers");
                return;
            }

            app.ConfigureAccessLevel("New AL", m_sAccountName, Readers, "Never On", out iStatus);

            if(iStatus > 0)
            {
                MessageBox.Show(iStatus.ToString());
            }
        }

        private void GetMobileCredentials_Click(object sender, EventArgs e)
        {
            object accounts = new WPAccountClass();
            this.app.GetAccounts(out accounts);
            if (accounts != null)
            {
                object[] foo = (object[])accounts;
                int nSize = foo.Length;
                for (int i = 0; i < nSize; i++)
                {
                    IAccount obj = (IAccount)foo[i];
                    object mobileVendors = new MobileVendorDetailClass();
                    this.app.GetMobileVendorConfigurationsByAcctID(obj.AccountID, out mobileVendors);

                    //var vendorDetails = new JArray() as dynamic;

                    if (mobileVendors != null)
                    {
                        string st = "Account: " + obj.AccountName + "\n";
                        object[] mVendors = (object[])mobileVendors;
                        int nVendors = mVendors.Length;
                        for (int j = 0; j < nVendors; j++)
                        {
                            IMobileVendorDetail objVendor = (IMobileVendorDetail)mVendors[j];
                            //dynamic vendor = new JObject();
                            //vendor.ClientID = objVendor.ClientID;
                            //vendor.ClientPassword = objVendor.ClientPassword;
                            //vendor.OrganizationID = objVendor.OrganizationID;
                            //vendor.Vendor = objVendor.Vendor;

                            st += "MobileVendor " + j + ": \n\tVendorId:" + objVendor.Vendor + ",\n\t{ClientID:" + objVendor.ClientID + ",\n\tClientPassword:" + objVendor.ClientPassword +
                                ",\n\tOrganizationID:" + objVendor.OrganizationID;
                            System.Diagnostics.Debug.WriteLine(st);
                            if (objVendor.PartNumberDetails != null)
                            {
                                object[] mPartNumberDetails = (object[])objVendor.PartNumberDetails;
                                int nPartNumbers = mPartNumberDetails.Length;
                                for (int k = 0; k < nPartNumbers; k++)
                                {
                                    IMobileCredPartNumberDetails objPartNumberDetails = (MobileCredPartNumberDetails)mPartNumberDetails[k];

                                    //vendor.PartNumberDetails = new JArray() as dynamic;
                                    //dynamic partNumber = new JObject();
                                    //partNumber.PartNumber = objPartNumberDetails.PartNumber;
                                    //partNumber.TotalCards = objPartNumberDetails.TotalCards;
                                    //partNumber.AvailableCards = objPartNumberDetails.AvailableCards;
                                    //partNumber.ExpiryDate = objPartNumberDetails.ExpiryDate;
                                    //partNumber.CredentialTypeID = objPartNumberDetails.CredentialTypeID;
                                    //vendor.PartNumberDetails.Add(partNumber);

                                    st = st + ",\n\tPartNumberDetails " + k + ": \n\t\t{PartNumber:" + objPartNumberDetails.PartNumber + ",\n\t\tTotalCards:" + objPartNumberDetails.TotalCards
                                        + ",\n\t\tAvailableCards:" + objPartNumberDetails.AvailableCards + ",\n\t\tExpiryDate:" + objPartNumberDetails.ExpiryDate
                                            + ",\n\t\tCredentialTypeID:" + objPartNumberDetails.CredentialTypeID + "}";

                                    //string s = "\npartNumber:" + partNumber + "\ntotalCards=" + totalCards + "\navailableCards=" + availableCards
                                    //    + "\nexpiryDate=" + expiryDate + "\ncredentialTypeId=" + credentialTypeId;
                                    //System.Diagnostics.Debug.WriteLine(s);
                                }
                                st = st + "}\n\n";

                            }
                            //vendorDetails.Add(vendor);                            
                        }
                        System.Diagnostics.Debug.WriteLine(st);
                        MessageBox.Show(st);
                    }
                    else
                        MessageBox.Show("Mobile Credentials are not available for Account: " + obj.AccountName);
                }
            }
            return;
        }

        private void getSubAccounts_Click(object sender, EventArgs e)
        {
            this.cb_subAccouts.Items.Clear();
            this.SubAccountMap.Clear();
            object subaccounts = new WPAccountClass();
            this.app.GetSubAccountsByAccountID(this.AccountMap[this.cmbAccounts.Text], out subaccounts);
            if (subaccounts != null)
            {
                object[] foo = (object[])subaccounts;
                int nSize = foo.Length;
                for (int i = 0; i < nSize; i++)
                {
                    IAccount obj = (IAccount)foo[i];
                    this.SubAccountMap.Add(obj.AccountName, obj.AccountID);
                    this.cb_subAccouts.Items.Add(obj.AccountName);
                }
                if (nSize > 0)
                    this.cb_subAccouts.SelectedIndex = 0;
            }

        }

        private void cb_subAccouts_SelectedIndexChanged(object sender, EventArgs e)
        {
            string strDetails = "";
            //object account = new WPAccountClass();
            //this.app.GetAccountByAcctID(this.AccountMap[this.cmbAccounts.Text], out account);
            //if (account != null)
            //{
            //IAccount theAccount = (IAccount)account;
            m_sSubAccountName = this.cb_subAccouts.Text;
            strDetails = ("Sub Account Name: " + m_sSubAccountName) + "\n Sub Account ID : " + this.SubAccountMap[this.cb_subAccouts.Text];
            //}
            //SubAccount 
            this.cmbCards.Items.Clear();
            this.cmbAccessLevels.Items.Clear();
            this.cmbCardHolders.Items.Clear();
            this.cmbNoteFields.Items.Clear();
            this.cmbResCardHolders.Items.Clear();

            MessageBox.Show(strDetails);
        }

        private void button_AddCard_Click(object sender, EventArgs e)
        {
            if (string.IsNullOrEmpty(m_sAccountName))
            {
                MessageBox.Show("Select Account First!!");
                return;
            }
            if (string.IsNullOrEmpty(m_sSubAccountName))
            {
                MessageBox.Show("Select SubAccount First!!");
                return;
            }

            ICard card = new CardClass();
            card.CardNumber = this.textBox_cardno.Text;
            card.CardHolderID = 0;
            card.CardStatus = 1;
            card.AccessLevelName = "DP_AC1_SA2_AL1";
            card.AccessLevels = null;
            
            card.ActivationDate = System.DateTime.Now.ToString();
            card.Issue = 0;
            card.NetAXSCardType = 0;
            card.NetAXSLimitedCard = 0;
            card.NetAXSTempCard = 0;
            card.NetAXSUsageLimit = 0;
            card.PIN1 = "";
            card.PIN2 = "";
            card.PRO3000CardType = 0;
            card.SubAccountName = m_sSubAccountName;
            card.AccountName = m_sAccountName;
            int status;
            this.app.AddCard((Card)card, out status);
            MessageBox.Show("AddCard Status " + status);
        }

        private void button_editcard_Click(object sender, EventArgs e)
        {
            if (theCard == null)
            {
                MessageBox.Show("Select Card First!!");
                return;
            }
            object cards = new CardClass();
            this.app.GetCardsByCHID(2007, out cards);
            if (cards != null)
            {
                object[] foo = (object[])cards;
                int nSize = foo.Length;
                if (nSize > 0)
                {
                    theCard = (ICard)foo[0];
                }
            }
            //theCard.CardStatus = 1;
            //theCard.PIN1 = theCard.PIN1 + "1";
            theCard.ExpirationDate = System.DateTime.Now.ToString();
            theCard.SubAccountName = m_sSubAccountName;
            theCard.AccountName = m_sAccountName;
            int status;            
            this.app.EditCard(theCard.CardNumber, m_sAccountName, m_sSubAccountName, (Card)theCard, out status);
            MessageBox.Show("EditCard Status " + status);

        }

        private void button_delCard_Click(object sender, EventArgs e)
        {
            if (theCard == null)
            {
                MessageBox.Show("Select Card First!!");
                return;
            }
            int status;
            this.app.DeleteCard(theCard.CardNumber, m_sAccountName, m_sSubAccountName, out status);
            MessageBox.Show("DeleteCard Status " + status);

        }

        private void button_addCardHolder_Click(object sender, EventArgs e)
        {
            if (string.IsNullOrEmpty(m_sAccountName))
            {
                MessageBox.Show("Select Account First!!");
                return;
            }
            if (string.IsNullOrEmpty(m_sSubAccountName))
            {
                MessageBox.Show("Select SubAccount First!!");
                return;
            }

            ICardHolder cardholder = new CardHolderClass();
            cardholder.FirstName = textBox_fname.Text;
            cardholder.LastName = textBox_lname.Text;
            cardholder.SubAccountName = m_sSubAccountName;
            cardholder.AccountName = m_sAccountName;
            int status;
            this.app.AddCardHolder((CardHolder)cardholder, out status);
            MessageBox.Show("AddCard Status " + status);

        }

        private void button_EditCardHolder_Click(object sender, EventArgs e)
        {
            if (theCardHolder == null)
            {
                MessageBox.Show("Select Card First!!");
                return;
            }
            theCardHolder.FirstName = textBox_fname.Text;
            theCardHolder.LastName = textBox_lname.Text;
            theCardHolder.SubAccountName = m_sSubAccountName;
            theCardHolder.AccountName = m_sAccountName;
            int status;
            this.app.EditCardHolder(theCardHolder.CardHolderID, (CardHolder)theCardHolder, out status);
            MessageBox.Show("EditCard Status " + status);
        }

        private void button_deleteCardHolder_Click(object sender, EventArgs e)
        {
            if (theCardHolder == null)
            {
                MessageBox.Show("Select Card First!!");
                return;
            }
            int status;
            this.app.DeleteCardHolder(theCardHolder.CardHolderID, 0, 0, out status);
            MessageBox.Show("EditCard Status " + status);
        }

        private void button_GetCHsWithExtRefID_Click(object sender, EventArgs e)
        {
            this.cmbCardHolders.Items.Clear();
            //for the return from getcardholdersbyaccountname()
            object cardHolders = new CardHolderClass();
            // Now we got the _ComObject on GetCardHoldersByAccountName()
            this.app.GetCardHoldersWithExtRefID(this.AccountMap[m_sAccountName], this.SubAccountMap[m_sSubAccountName], out cardHolders);
            if (cardHolders != null)
            {
                object[] CHs = (object[])cardHolders;

                //DetailView details = new DetailView();
                //details.populateCardHolders(CHs);
                //details.Show();

                int nCHs = CHs.Length;
                for (int j = 0; j < nCHs; j++)
                {
                    // Decoding the General Object into a specific 
                    //CardHolder Object through NCIHelperLib.ICardHolder
                    ICardHolder objCardHolder = (ICardHolder)CHs[j];
                    this.cmbCardHolders.Items.Add(objCardHolder.CardHolderID);
                }
                if (nCHs > 0)
                    this.cmbCardHolders.SelectedIndex = 0;
            }
        }

        private void button_GetCHsWOExtRefID_Click(object sender, EventArgs e)
        {
            this.cmbCardHolders.Items.Clear();
            //for the return from getcardholdersbyaccountname()
            object cardHolders = new CardHolderClass();

            this.app.GetCardHoldersWithoutExtRefID(this.AccountMap[m_sAccountName], this.SubAccountMap[m_sSubAccountName], out cardHolders);
            if (cardHolders != null)
            {
                object[] CHs = (object[])cardHolders;

                //DetailView details = new DetailView();
                //details.populateCardHolders(CHs);
                //details.Show();

                int nCHs = CHs.Length;
                for (int j = 0; j < nCHs; j++)
                {
                    // Decoding the General Object into a specific 
                    //CardHolder Object through NCIHelperLib.ICardHolder
                    ICardHolder objCardHolder = (ICardHolder)CHs[j];
                    this.cmbCardHolders.Items.Add(objCardHolder.CardHolderID);
                }
                if (nCHs > 0)
                    this.cmbCardHolders.SelectedIndex = 0;
            }

        }
    }
}


